/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.sas;

import com.ibm.hwmca.base.rsf.sas.CredentialCompletionStatus;
import com.ibm.hwmca.base.rsf.sas.CredentialStore;
import com.ibm.hwmca.base.rsf.sas.CredentialStoreAccessException;
import com.ibm.hwmca.base.rsf.sas.CredentialUtils;
import com.ibm.hwmca.base.rsf.sas.UnsupportedTargetException;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.rcs.sas.SysInfo;
import com.ibm.hwmca.fw.rcs.sas.SystemIdentifier;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.RsfMachineInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class LocalCredentialStore
implements CredentialStore {
    private static final String TRACE_MASKT = "XRSFCR T";
    private static final String TRACE_MASKF = "XRSFCR F";
    private static final String TRACE_MASKD = "XRSFCR D";
    static final String PERSISTENCE_NAME = "com.ibm.hwmca.base.rsf.sas.LocalCredentialStore";
    private static LocalCredentialStore store = new LocalCredentialStore();
    private boolean update = false;
    Persistent persistentData = null;
    private String currentMachType;
    private String currentMachModel;
    private String currentMachSerial;

    private LocalCredentialStore() {
        PersistenceManager persMgr = PersistenceManager.getPersistenceManager();
        if (persMgr.contains(PERSISTENCE_NAME)) {
            try {
                this.persistentData = (Persistent)persMgr.read(PERSISTENCE_NAME);
                Trace.trace(TRACE_MASKF, "Local Credential Store restored from persistent data");
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "Local Credential Store: Exception restoring persistent data");
                Trace.trace(TRACE_MASKF, pe);
                this.persistentData = new Persistent();
            }
        } else {
            Trace.trace(TRACE_MASKF, "Local Credential Store: Persistent data com.ibm.hwmca.base.rsf.sas.LocalCredentialStore unavailable");
            this.persistentData = new Persistent();
        }
    }

    public static final SystemIdentifier getLocalSystemIdentifier() {
        String machType = "";
        String machModel = "";
        String machSerial = "";
        try {
            RsfMachineInfo data = RsfMachineInfo.getLocalMachineInfo();
            machType = data.getMachineType();
            machModel = data.getMachineModel();
            machSerial = data.getMachineSerial();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "CredentialUtils.getLocalSystemIdentifier: Error getting machine data: ");
            Trace.trace(TRACE_MASKF, e);
        }
        Date updateDate = LocalCredentialStore.store.persistentData.sysIdentifier == null || !machType.equals(LocalCredentialStore.store.persistentData.sysIdentifier.machineType) || !machModel.equals(LocalCredentialStore.store.persistentData.sysIdentifier.machineModel) || !machSerial.equals(LocalCredentialStore.store.persistentData.sysIdentifier.serialNumber) ? new Date() : LocalCredentialStore.store.persistentData.sysIdentifier.lastUpdateTimestamp;
        return new SystemIdentifier(machType, machModel, machSerial, null, updateDate);
    }

    public static LocalCredentialStore getCredentialStore() {
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCredentialStored(String target, boolean stored) {
        Trace.trace(TRACE_MASKT, "-> LocalCredentialStore::setCredentialStored() for " + target + " to " + stored);
        if (this.persistentData.notStoredTargets == null) {
            Trace.trace(TRACE_MASKF, "LocalCredentialStore.setCredentialStored() no stored targets array.  Building new one.");
            this.persistentData.notStoredTargets = new ArrayList();
        }
        LocalCredentialStore localCredentialStore = this;
        synchronized (localCredentialStore) {
            if (stored) {
                if (this.persistentData.notStoredTargets.remove(target)) {
                    this.persist();
                }
            } else if (!this.persistentData.notStoredTargets.contains(target)) {
                this.persistentData.notStoredTargets.add(target);
                this.persist();
            }
        }
        Trace.trace(TRACE_MASKT, "<- LocalCredentialStore::setCredentialStored()");
    }

    public boolean isCredentialStored(String target) {
        boolean retval = false;
        if (this.persistentData.notStoredTargets == null) {
            Trace.trace(TRACE_MASKF, "LocalCredentialStore.isCredentialStored() no stored targets array");
        } else {
            retval = !this.persistentData.notStoredTargets.contains(target);
        }
        Trace.trace(TRACE_MASKT, "<> LocalCredentialStore::isCredentialStored() returning " + retval);
        return retval;
    }

    public String[] getCacheTargets() {
        String[] targets = new String[this.persistentData.cachedCredentials.size()];
        int index = 0;
        Iterator i = this.persistentData.cachedCredentials.keySet().iterator();
        while (i.hasNext()) {
            String target = (String)i.next();
            if (index + 1 > targets.length) {
                Trace.trace(TRACE_MASKF, "LocalCredentialStore.getCacheTargets no room for target:" + target);
                continue;
            }
            targets[index++] = target;
        }
        return targets;
    }

    public Date getInitDate() {
        return this.persistentData.startDate;
    }

    public SysInfo getCredential(Object target, boolean noUpdate) {
        try {
            if (noUpdate && target == null) {
                Trace.trace(TRACE_MASKF, "Local credential store: returning credential with no update check");
                return this.persistentData.localCredential;
            }
            return this.getCredential(target);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Local credential store.getCredential(boolean) exception");
            return null;
        }
    }

    public SysInfo getCredential(Object target) throws UnsupportedTargetException, CredentialStoreAccessException {
        if (target == null) {
            if (this.persistentData.localCredential == null) {
                Trace.trace(TRACE_MASKF, "Local credential store: returning null credential");
                return null;
            }
            if (this.update) {
                Trace.trace(TRACE_MASKF, "LocalCredentialStore: get credentials for update request");
                return this.persistentData.localCredential;
            }
            String machType = "";
            String machModel = "";
            String machSerial = "";
            try {
                RsfMachineInfo data = RsfMachineInfo.getLocalMachineInfo();
                machType = data.getMachineType();
                machModel = data.getMachineModel();
                machSerial = data.getMachineSerial();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "CredentialUtils.getLocalSystemIdentifier: Error getting machine data: ");
                Trace.trace(TRACE_MASKF, e);
                return this.persistentData.localCredential;
            }
            if (!(machType.equals(this.persistentData.sysIdentifier.machineType) && machModel.equals(this.persistentData.sysIdentifier.machineModel) && machSerial.equals(this.persistentData.sysIdentifier.serialNumber))) {
                Trace.trace(TRACE_MASKF, "LocalCredentialStore: updating credentials because vpd mismatch: New/old: Machine type: " + machType + "/" + this.persistentData.sysIdentifier.machineType + " Machine model: " + machModel + "/" + this.persistentData.sysIdentifier.machineModel + " Machine serial: " + machSerial + "/" + this.persistentData.sysIdentifier.serialNumber);
                if (!CredentialUtils.updateLocalSystemCredentialInfoSynchronous().equals(CredentialCompletionStatus.SUCCESS)) {
                    Trace.trace(TRACE_MASKF, "LocalCredentialStore: update not successful");
                } else {
                    Trace.trace(TRACE_MASKF, "LocalCredentialStore: update successful, mach info updated");
                    this.persistentData.sysIdentifier.machineType = machType;
                    this.persistentData.sysIdentifier.machineModel = machModel;
                    this.persistentData.sysIdentifier.serialNumber = machSerial;
                    this.persist();
                }
            }
            Trace.trace(TRACE_MASKF, "LocalCredentialStore: get credential: " + this.persistentData.localCredential.getMachineId() + "/" + this.persistentData.localCredential.getPassword() + " Machine data: " + this.persistentData.sysIdentifier.toXml());
            return this.persistentData.localCredential;
        }
        try {
            String mtms = (String)target;
            return (SysInfo)this.persistentData.cachedCredentials.get(target);
        }
        catch (ClassCastException e) {
            throw new UnsupportedTargetException("Local credential store supports String only targets.  " + target.getClass() + " target not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeCredential(Object target, SysInfo credential) throws UnsupportedTargetException, CredentialStoreAccessException {
        if (credential == null) {
            throw new IllegalArgumentException("null credential or target found");
        }
        LocalCredentialStore localCredentialStore = this;
        synchronized (localCredentialStore) {
            if (target == null) {
                Trace.trace(TRACE_MASKF, "LocalCredentials:storeCredential for local - no sysIdentifier provided - indicates a password update");
                this.persistentData.localCredential = credential;
            } else {
                try {
                    String mtms = (String)target;
                }
                catch (ClassCastException e) {
                    throw new UnsupportedTargetException("Local credential store supports String only targets.  " + target.getClass() + " target not supported");
                }
                if (credential.equals(this.persistentData.cachedCredentials.get(target))) {
                    return;
                }
                this.persistentData.cachedCredentials.put(target, credential);
            }
            this.persist();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeLocalCredential(SysInfo credential, SystemIdentifier identifier) {
        if (credential == null || identifier == null) {
            throw new IllegalArgumentException("null credential or null identifier found");
        }
        LocalCredentialStore localCredentialStore = this;
        synchronized (localCredentialStore) {
            if (this.persistentData.sysIdentifier == null || !identifier.lastUpdateTimestamp.equals(this.persistentData.sysIdentifier.lastUpdateTimestamp)) {
                this.persistentData.sysIdentifier = identifier;
            } else if (credential.equals(this.persistentData.localCredential)) {
                Trace.trace(TRACE_MASKF, "LocalCredentialStore: credential to be stored already there");
                return;
            }
            this.persistentData.localCredential = credential;
            this.persist();
        }
        Trace.trace(TRACE_MASKF, "LocalCredentialStore: store credential: " + this.persistentData.localCredential.getMachineId() + "/" + this.persistentData.localCredential.getPassword() + " Machine data: " + this.persistentData.sysIdentifier.toXml());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCredential(Object target) throws UnsupportedTargetException, CredentialStoreAccessException {
        LocalCredentialStore localCredentialStore = this;
        synchronized (localCredentialStore) {
            if (target == null) {
                if (this.persistentData.localCredential == null) {
                    return;
                }
                this.persistentData.localCredential = null;
            } else {
                try {
                    String mtms = (String)target;
                }
                catch (ClassCastException e) {
                    throw new UnsupportedTargetException("Local credential store supports String only targets.  " + target.getClass() + " target not supported");
                }
                if (this.persistentData.cachedCredentials.containsKey(target)) {
                    this.persistentData.cachedCredentials.remove(target);
                } else {
                    return;
                }
            }
            this.persist();
        }
    }

    public synchronized boolean setUpdate(boolean update) {
        if (update == this.update) {
            return false;
        }
        this.update = update;
        return this.update;
    }

    private void persist() {
        Trace.trace(TRACE_MASKT, "-> persist()");
        try {
            PersistenceManager.getPersistenceManager().write(PERSISTENCE_NAME, this.persistentData);
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, "Unable to persist persistent data: " + pe.getMessage());
        }
        Trace.trace(TRACE_MASKT, "<- persist()");
    }

    private static class Persistent
    implements PersistentData {
        private static final long serialVersionUID = 1L;
        public HashMap cachedCredentials = new HashMap();
        public SysInfo localCredential = null;
        public Date startDate = new Date();
        public SystemIdentifier sysIdentifier = null;
        public ArrayList notStoredTargets = new ArrayList();
        int version = 1;

        private Persistent() {
        }
    }
}

